<?php
require_once 'config.php';

class OpenAI {
    private $apiKey;
    
    public function __construct($apiKey = null) {
        $this->apiKey = $apiKey ?: OPENAI_API_KEY;
    }
    
    // إرسال رسالة إلى ChatGPT
    public function sendMessage($message, $conversationHistory = [], $systemPrompt = "You are a helpful assistant.") {
        if (empty($this->apiKey) {
            // إذا لم يكن هناك مفتاح API، نرجع رد تجريبي
            return $this->getMockResponse($message);
        }
        
        $messages = [
            ['role' => 'system', 'content' => $systemPrompt]
        ];
        
        // إضافة تاريخ المحادثة
        foreach ($conversationHistory as $msg) {
            $messages[] = [
                'role' => $msg['sender'] === 'user' ? 'user' : 'assistant',
                'content' => $msg['text']
            ];
        }
        
        // إضافة الرسالة الحالية
        $messages[] = ['role' => 'user', 'content' => $message];
        
        $data = [
            'model' => 'gpt-3.5-turbo',
            'messages' => $messages,
            'max_tokens' => 1000,
            'temperature' => 0.7
        ];
        
        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => OPENAI_BASE_URL . '/chat/completions',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => json_encode($data),
            CURLOPT_HTTPHEADER => [
                'Content-Type: application/json',
                'Authorization: Bearer ' . $this->apiKey
            ]
        ]);
        
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        if ($httpCode !== 200) {
            error_log("OpenAI API Error: " . $response);
            return "عذراً، حدث خطأ في الاتصال بالذكاء الاصطناعي.";
        }
        
        $responseData = json_decode($response, true);
        
        return $responseData['choices'][0]['message']['content'] ?? "عذراً، لم أستطع فهم الرد.";
    }
    
    // تحويل النص إلى كلام (TTS)
    public function textToSpeech($text, $voice = 'alloy') {
        if (empty($this->apiKey)) {
            // إذا لم يكن هناك مفتاح API، نرجع ملف صوتي تجريبي
            return $this->getMockAudio($text);
        }
        
        $data = [
            'model' => 'tts-1',
            'input' => $text,
            'voice' => $voice,
            'response_format' => 'mp3'
        ];
        
        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => OPENAI_BASE_URL . '/audio/speech',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => json_encode($data),
            CURLOPT_HTTPHEADER => [
                'Content-Type: application/json',
                'Authorization: Bearer ' . $this->apiKey
            ]
        ]);
        
        $audioData = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        if ($httpCode !== 200) {
            error_log("OpenAI TTS Error: HTTP $httpCode");
            return null;
        }
        
        return $audioData;
    }
    
    // رد تجريبي عندما لا يكون هناك مفتاح API
    private function getMockResponse($message) {
        $responses = [
            "مرحباً! أنا مساعدك الذكي. كيف يمكنني مساعدتك اليوم؟",
            "شكراً لرسالتك. أتطلع لمساعدتك في أي استفسار لديك.",
            "هذا مثير للاهتمام! هل يمكنك إعطائي المزيد من التفاصيل؟",
            "أفهم طلبك. سأقوم بمساعدتك في هذا الأمر.",
            "هذا سؤال جيد! دعني أفكر في أفضل طريقة للإجابة عليه."
        ];
        
        return $responses[array_rand($responses)];
    }
    
    // ملف صوتي تجريبي
    private function getMockAudio($text) {
        // في الإنتاج الحقيقي، قد ترجع ملف صوتي افتراضي
        return null;
    }
}
?>